# Haiven Memory

**Every brilliant idea you've ever had. One search away.**

Never explain yourself to AI twice. Capture once, remembered everywhere. Works across ChatGPT, Claude, Grok, Perplexity, and Gemini.

---

## What It Does

Haiven remembers what matters across all your AI conversations:
- **Decisions** you've made ("I decided to use TypeScript for this project")
- **Preferences** AI should know ("I prefer concise explanations")
- **Context** that shouldn't need repeating ("I work at Acme Corp on the payments team")
- **Insights** worth keeping ("The API rate limit is 100 req/min")

Search any of it instantly. One search away.

---

## Installation

### Option 1: Load Unpacked (Development)

1. Clone or download this repository
2. Open Chrome → `chrome://extensions/`
3. Enable "Developer mode" (top-right toggle)
4. Click "Load unpacked"
5. Select the `chrome-extension` folder

### Option 2: Chrome Web Store

*(Coming soon)*

---

## Setup

### Step 1: Get Your User ID

1. Go to [safehaiven.com](https://www.safehaiven.com)
2. Log in or create an account
3. Open browser console (F12)
4. Run: `JSON.parse(localStorage.getItem('haiven_user')).id`
5. Copy the UUID

### Step 2: Configure Extension

1. Click the extension icon
2. Click Settings (gear icon)
3. Paste your User ID
4. Set API Endpoint to `https://api.safehaiven.com`
5. Save

---

## How to Use

### Search First

Open the popup and search your memories instantly:
- "What did I decide about the database?"
- "My React preferences"
- "Meeting notes from last week"

### Capture Decisions

When you make a decision, tell Haiven:
- "I've decided to use PostgreSQL instead of MongoDB"
- "Going with the flat rate pricing model"

Find it later with "What did I decide about..."

### Auto-Capture

The extension listens for important moments:
- "Haiven, remember this..."
- "Save this for later..."
- "Remember that I prefer..."

### Quick Capture

1. Highlight any text on a page
2. Click the extension icon
3. Click "Capture Memory"

---

## Supported Platforms

| Platform       | Status |
| -------------- | ------ |
| ChatGPT        | ✓      |
| Claude         | ✓      |
| Grok           | ✓      |
| Perplexity     | ✓      |
| Gemini         | ✓      |

---

## Privacy

- **Your data stays yours**: Memories go only to your Haiven instance
- **No tracking**: Zero analytics or telemetry to third parties
- **Open source**: All code is auditable
- **Full control**: Export or delete anytime

---

## Troubleshooting

### "User not set up" Error

1. Click extension icon → Settings
2. Enter your User ID
3. Save Settings

### Memories Not Saving

Check:
1. User ID is configured correctly
2. API endpoint is `https://api.safehaiven.com`
3. You're on a supported platform

Debug: Open console (F12) and look for `Haiven:` logs

### Extension Not Working on Platform

1. Refresh the page
2. Check URL matches supported domain
3. Try reloading extension in `chrome://extensions/`

---

## Keyboard Shortcuts

| Shortcut         | Action              |
| ---------------- | ------------------- |
| Ctrl/Cmd + Enter | Save memory (popup) |

---

## Development

### File Structure

```
chrome-extension/
├── manifest.json     # Extension config
├── background.js     # Service worker
├── content.js        # Auto-capture
├── popup.html/.js    # Main UI
├── settings.html/.js # Configuration
└── icon.png          # Extension icon
```

### Testing

1. Enable extension in `chrome://extensions/`
2. Open ChatGPT
3. Say "Haiven, remember I love TypeScript"
4. Check dashboard - memory should appear

### API Endpoints

```javascript
// Search memories
POST /api/memory/search
{ userId, query, limit, threshold }

// Save memory
POST /api/memory/store/fast
{ userId, content, tags, metadata }

// Smart capture
POST /api/memory/smart-capture
{ userId, userMessage, autoDetect }
```

---

## FAQ

**Q: Does this work with the Custom GPT?**

Yes! The extension works in ALL ChatGPT sessions, complementing the Custom GPT approach.

**Q: Will this slow down my browser?**

No. The extension only activates on supported AI platforms with minimal overhead.

**Q: Can I use this at work?**

Yes, if your company allows extensions. Consider self-hosting for extra security.

**Q: How do I export my memories?**

Go to your Haiven dashboard → Settings → Export.

---

## License

MIT © Haiven

---

**Every brilliant idea. One search away.**

*Version 4.0.0*
