# Haiven Premium Redesign - Quick Reference Card

> **TL;DR**: Drop in CSS, update panel structure, ship it. 5 minutes.

---

## 🎨 Color Palette

```css
Primary:     #1FB6FF  (Electric Cyan)
Background:  rgba(17, 17, 23, 0.92)  (Deep Space + Glass)
Text:        rgba(255, 255, 255, 0.95)  (High contrast)
```

---

## 📐 Key Dimensions

```
Panel:        380px × auto (max 90vh)
Buttons:      100% width, 44px height
Toggle:       44px × 24px
Icon:         22px
Radius:       20px (panel), 12px (buttons)
```

---

## ⚡ Animations

| Element        | Duration | Easing      | Effect                   |
| -------------- | -------- | ----------- | ------------------------ |
| Panel entrance | 0.6s     | Spring      | Scale + blur + translate |
| Button hover   | 0.2s     | Ease-out    | Lift 2px, glow           |
| Icon pulse     | 3s       | Ease-in-out | Scale 1.05, breathing    |
| Toggle         | 0.3s     | Spring      | Slide + glow             |

**Spring easing**: `cubic-bezier(0.34, 1.56, 0.64, 1)`

---

## 🎯 Visual Hierarchy

```
Primary CTA:        70% visual weight (gradient, shimmer, glow)
Secondary actions:  25% visual weight (grid, subtle)
Toggle:             5% visual weight (footer)
```

---

## ⌨️ Keyboard Shortcuts

| Shortcut     | Action                           |
| ------------ | -------------------------------- |
| `⌘/Ctrl + H` | Toggle panel                     |
| `⌘/Ctrl + I` | Inject context (when panel open) |
| `Esc`        | Close panel                      |
| `Tab`        | Navigate actions                 |

---

## 🎨 Design Tokens (CSS Variables)

```css
--haiven-primary: #1fb6ff;
--haiven-gradient-primary: linear-gradient(135deg, #1fb6ff, #00d4ff);
--haiven-surface-elevated: rgba(17, 17, 23, 0.92);
--haiven-glass-border: rgba(255, 255, 255, 0.08);
--haiven-text-primary: rgba(255, 255, 255, 0.95);
--haiven-ease-spring: cubic-bezier(0.34, 1.56, 0.64, 1);
```

---

## 📦 File Structure

```
chrome-extension/
├── haiven-redesign-preview.html     ← Preview (open in browser)
├── haiven-premium-styles.css        ← Production CSS (15 KB)
├── DESIGN_SPEC.md                   ← Full documentation (14 KB)
├── INTEGRATION_GUIDE.md             ← Step-by-step (9.8 KB)
├── REDESIGN_SUMMARY.md              ← Executive overview (11 KB)
└── QUICK_REFERENCE.md               ← This file
```

---

## 🚀 Quick Integration (3 steps)

### 1. Add CSS

```javascript
const link = document.createElement('link');
link.rel = 'stylesheet';
link.href = chrome.runtime.getURL('haiven-premium-styles.css');
document.head.appendChild(link);
```

### 2. Update Panel Structure

```javascript
const panel = document.createElement('div');
panel.id = 'haiven-panel';
panel.innerHTML = `
  <div>
    <div>
      <div>
        <span class="haiven-icon">🧠</span>
        <span>Haiven</span>
      </div>
      <button id="haiven-close">×</button>
    </div>
    <div>Connected to ${platform}</div>
  </div>
  <div>
    <button id="haiven-inject-context" class="haiven-cta">
      <span>✨</span>
      <span>Inject Smart Context</span>
      <span class="haiven-cta-kbd">⌘I</span>
    </button>
    <!-- Secondary actions... -->
  </div>
`;
document.body.appendChild(panel);
```

### 3. Test

- Open ChatGPT
- Press `Ctrl+H`
- Verify animations work

**Done!**

---

## 🎨 Glassmorphism Recipe

```css
background: rgba(17, 17, 23, 0.92); /* Semi-transparent */
backdrop-filter: blur(40px) saturate(180%); /* Glass effect */
-webkit-backdrop-filter: blur(40px) saturate(180%); /* Safari */
border: 1px solid rgba(255, 255, 255, 0.08); /* Subtle border */
box-shadow: 0 24px 48px rgba(0, 0, 0, 0.4); /* Depth */
```

---

## ⚡ Performance Tips

### ✅ Fast

```css
transform: translateY(-2px); /* GPU-accelerated */
opacity: 0.9; /* GPU-accelerated */
```

### ❌ Slow

```css
margin-top: -2px; /* Triggers layout */
box-shadow: ...; /* CPU-bound */
```

---

## 🎯 Button Hover Pattern

```css
.button {
  transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.button:hover {
  transform: translateY(-1px);
  border-color: var(--haiven-primary);
  box-shadow: 0 8px 24px rgba(31, 182, 255, 0.25);
}

.button:active {
  transform: scale(0.98);
}
```

---

## 📊 Contrast Ratios (WCAG AAA)

| Element        | Ratio | Pass   |
| -------------- | ----- | ------ |
| Primary text   | 15:1  | ✅ AAA |
| Secondary text | 9:1   | ✅ AAA |
| CTA text       | 8:1   | ✅ AAA |

---

## 🎨 Shadow Layers

```css
/* Panel shadow (depth + border) */
box-shadow:
  0 24px 48px rgba(0, 0, 0, 0.4),
  /* Main shadow */ 0 0 0 1px rgba(255, 255, 255, 0.08); /* Border */

/* Button shadow (glow) */
box-shadow:
  0 8px 24px rgba(31, 182, 255, 0.25),
  /* Glow */ 0 0 0 1px rgba(255, 255, 255, 0.1) inset; /* Highlight */
```

---

## 🔧 Z-Index Scale

```
1000000  Modal overlays
999999   Modals
999998   Panel
999997   Floating button
```

---

## 🎯 The "One Thing" Checklist

When designing any new UI element, ask:

- [ ] Does it have ONE primary action?
- [ ] Does it use spring physics?
- [ ] Does it have glassmorphism?
- [ ] Does it pass WCAG AAA?
- [ ] Does it feel delightful?

If yes to all, ship it.

---

## 🚨 Common Pitfalls

### ❌ Don't

```css
display: none; /* Breaks animations */
outline: none; /* Breaks accessibility */
animation-duration: 0.1s; /* Too fast, not delightful */
```

### ✅ Do

```css
opacity: 0;
pointer-events: none; /* Allows animations */
outline: 2px solid var(--haiven-primary); /* Visible focus */
animation-duration: 0.6s; /* Feels premium */
```

---

## 📱 Responsive Breakpoints

```css
@media (max-width: 480px) {
  #haiven-panel {
    width: calc(100vw - 32px);
    right: 16px;
  }
}
```

---

## 🎨 Icon Pulse Animation

```css
@keyframes haivenIconPulse {
  0%,
  100% {
    transform: scale(1);
    filter: drop-shadow(0 2px 8px rgba(31, 182, 255, 0.3));
  }
  50% {
    transform: scale(1.05);
    filter: drop-shadow(0 4px 16px rgba(31, 182, 255, 0.5));
  }
}

.haiven-icon {
  animation: haivenIconPulse 3s ease-in-out infinite;
}
```

---

## 🎯 Testing Checklist

### Visual

- [ ] Panel positioned correctly
- [ ] Glassmorphism visible
- [ ] Gradients smooth

### Animations

- [ ] Entrance (scale + blur + translate)
- [ ] Icon pulse (3s cycle)
- [ ] Button hovers (lift + glow)
- [ ] Shimmer on CTA

### Interactions

- [ ] Primary CTA works
- [ ] Secondary actions work
- [ ] Toggle works
- [ ] Keyboard shortcuts work

### Accessibility

- [ ] Focus states visible
- [ ] Tab order logical
- [ ] Contrast ratios pass

---

## 📞 Support

**Questions?**

- Read `INTEGRATION_GUIDE.md` for step-by-step
- Read `DESIGN_SPEC.md` for full details
- Open `haiven-redesign-preview.html` to preview

**Issues?**

- Check browser console
- Test in incognito mode
- Verify CSS is loading

---

## 🎉 Ship Checklist

- [ ] CSS integrated
- [ ] Panel structure updated
- [ ] Tested on ChatGPT
- [ ] Tested on Claude
- [ ] Tested on Grok
- [ ] Keyboard shortcuts work
- [ ] Accessibility verified
- [ ] Performance measured (<16ms frames)
- [ ] A/B test configured
- [ ] Deployed to production

---

**Version**: 2.0
**Last Updated**: December 2025
**Status**: Production-ready

_Ship it with confidence._
